﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace OpenAPI_App_Manager
{
    public partial class PSWCBrowser : UserControl
    {
        private OpenAPIWrapper openAPIHandler;
        public OpenAPIWrapper OpenAPIHandler
        {
            get
            {
                return openAPIHandler;
            }
            set
            {
                openAPIHandler = value;
                if (openAPIHandler == null || openAPIHandler.MFP == null || openAPIHandler.MFP.Address == string.Empty || !openAPIHandler.MFP.OpenAPIEnabled)
                {
                    this.Enabled = false;
                    webBrowserPSWC.DocumentText = string.Empty;
                    textBoxPSWCAddress.Text = string.Empty;
                    return;
                }
                else
                {
                    UpdateBrowser();
                    this.Enabled = true;
                }
            }
        }

        public PSWCBrowser()
        {
            InitializeComponent();
        }

        private void webBrowserPSWC_Navigating(object sender, WebBrowserNavigatingEventArgs e)
        {
            try
            {
                pictureBoxBusy.Visible = true;
                textBoxPSWCAddress.Text = e.Url.AbsoluteUri;
            }
            catch { }
        }

        private void webBrowserPSWC_DocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
        {
            pictureBoxBusy.Visible = false;
        }

        private void buttonPSWCBack_Click(object sender, EventArgs e)
        {
            try
            {
                webBrowserPSWC.GoBack();
            }
            catch { }
        }

        private void buttonPSWCForward_Click(object sender, EventArgs e)
        {
            try
            {
                webBrowserPSWC.GoForward();
                textBoxPSWCAddress.Text = webBrowserPSWC.Url.AbsoluteUri;
            }
            catch { }
        }

        private void buttonPSWCRefresh_Click(object sender, EventArgs e)
        {
            try
            {
                webBrowserPSWC.Refresh();
                textBoxPSWCAddress.Text = webBrowserPSWC.Url.AbsoluteUri;
            }
            catch { }
        }

        private void buttonPSWCHome_Click(object sender, EventArgs e)
        {
            UpdateBrowser();
        }

        private void UpdateBrowser()
        {
            try
            {
                webBrowserPSWC.Navigate("http://" + openAPIHandler.MFP.Address);
                textBoxPSWCAddress.Text = webBrowserPSWC.Url.AbsoluteUri;
            }
            catch { }
        }

        private void buttonDeviceDescription_Click(object sender, EventArgs e)
        {
            try
            {
                webBrowserPSWC.Navigate("http://" + openAPIHandler.MFP.Address + "/OpenAPI/DeviceDescription/");
                textBoxPSWCAddress.Text = webBrowserPSWC.Url.AbsoluteUri;
            }
            catch { }
        }
    }
}
